<?php	if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Dispenser_sale_data extends CI_Controller {
	
	function __construct()	{
		parent::__construct();		
	}

	function index()	{	
		$this->list_dispenser_sale_data();
	}

	function list_dispenser_sale_data() {
		$this->_page_data['page_title']="List of Dispenser Sale Data";
		$this->_page_data['bredcrum']=array(
										'Dispenser Sales'=>'#',
										' Manage Dispenser Sales'=>site_url('gc/dispenser_sale_data/list_dispenser_sale_data'),
										'List Dispenser Sale Data'=>'#',
										);
		$this->load->view('gc/dispenser_sale_data_list.php',$this->_page_data);
	}
	
	function view_dispenser_sale_data() {
		$this->_page_data['page_title']="View Dispenser Sale Data";
		$this->_page_data['bredcrum']=array(
										'Dispenser Sales'=>'#',
										' Manage Dispenser Sales'=>site_url('gc/dispenser_sale_data/list_dispenser_sale_data'),
										'List Dispenser Sale Data'=>site_url('gc/dispenser_sale_data/list_dispenser_sale_data'),
										'View Dispenser Sale Data'=>'#',
										);
		$this->load->view('gc/dispenser_sale_data_view.php',$this->_page_data);
	}
	
	function manage_dispenser_sale_data($purpose=NULL) {
		admin_auth();
		if($purpose=='')
			$purpose='Add';
		
		$company_cond = array();
		$company_cond[] = array('where','is_active','1');
		$select_array = array(
								'table_name'=>TABLE_COMPANY_BRANCH,
								'table_fields'=>'company_branch_name,company_branch_id',
								'condition'=>$company_cond,
								'sort_by'=>'company_branch_id',
								'order_by_field'=>'company_branch_name',
								'order'=>'ASC',
								'limit'=>'',
								'offset'=>''
								);
		$company_data=$this->master_model->select_data($select_array);
		$company_cnt_data=count($company_data);
		$this->_page_data['company_branch_array'] = '';
		if($company_cnt_data > 0)
		{
			foreach($company_data as $cKey => $cValue)
			{
				$this->_page_data['company_branch_array'][''] = 'Select Company Branch';
				$this->_page_data['company_branch_array'][$cValue['company_branch_id']] = $cValue['company_branch_name'];
			}
		}
		
		$customer_cond = array();
		$customer_cond[] = array('where','is_active','1');
		$select_array = array(
								'table_name'=>TABLE_CUSTOMER,
								'table_fields'=>'customer_name,customer_id',
								'condition'=>$customer_cond,
								'sort_by'=>'customer_id',
								'order_by_field'=>'customer_name',
								'order'=>'ASC',
								'limit'=>'',
								'offset'=>''
								);
		$customer_data=$this->master_model->select_data($select_array);
		$customer_cnt_data=count($customer_data);
		$this->_page_data['customer_array'] = '';
		if($customer_cnt_data > 0)
		{
			foreach($customer_data as $cKey => $cValue)
			{
				$this->_page_data['customer_array'][''] = 'Select Customer Name';
				$this->_page_data['customer_array'][$cValue['customer_id']] = $cValue['customer_name'];
			}
		}
		
		$refill_cond = array();
		$refill_cond[] = array('where','is_active','1');
		$refill_cond[] = array('where','product_type','dispenser');
		$select_array = array(
								'table_name'=>TABLE_PRODUCT,
								'table_fields'=>'product_name,product_id',
								'condition'=>$refill_cond,
								'sort_by'=>'product_id',
								'order_by_field'=>'product_name',
								'order'=>'ASC',
								'limit'=>'',
								'offset'=>''
								);
		$refill_data=$this->master_model->select_data($select_array);
		$refill_cnt_data=count($refill_data);
		$this->_page_data['refill_array'] = '';
		if($refill_cnt_data > 0)
		{
			foreach($refill_data as $cKey => $cValue)
			{
				$this->_page_data['refill_array'][''] = 'Select Dispenser Name';
				$this->_page_data['refill_array'][$cValue['product_id']] = $cValue['product_name'];
			}
		}
		
		$this->_page_data['purpose']=$purpose;
		$this->_page_data['page_title']=$purpose." Dispenser Sale Data";
		$this->_page_data['bredcrum']=array(
										'Dispenser Sales'=>'#',
										' Manage Dispenser Sales'=>site_url('gc/dispenser_sale_data/list_dispenser_sale_data'),
										$purpose.' Dispenser Sale Data'=>'#',
										);
										
		$this->_page_data['form_action'] = 'gc/dispenser_sale_data/submit_dispenser_sale_data';
		$this->load->view('gc/dispenser_sale_data_manage.php',$this->_page_data);
	}
	
	function submit_dispenser_sale_data()
	{
		admin_auth();
		//print_r($_POST);
		$session_admin_id = $this->session->userdata('admin_id');
		$session_company_id=$this->session->userdata('company_id');
		$admin_type=$this->session->userdata('admin_type');
		$btn_confirm=check_injections_filter($this->input->post('btn_confirm')); 
		$branch_name=check_injections_filter($this->input->post('company_branch_id')); 
		$customer_id=check_injections_filter($this->input->post('customer_id')); 
		$sale_person_name=check_injections_filter($this->input->post('sale_person_name')); 
		$dispenser_id=check_injections_filter($this->input->post('dispenser_id')); 
		$dispenser_quantity=check_injections_filter($this->input->post('dispenser_quantity')); 
		$sale_date=check_injections_filter($this->input->post('sale_date')); 
		$contract_sign=check_injections_filter($this->input->post('contract_sign')); 
		$contract_start_date=check_injections_filter($this->input->post('contract_start_date')); 
		$contract_end_date=check_injections_filter($this->input->post('contract_end_date')); 
		$comments=check_injections_filter($this->input->post('comments')); 
		
		$contract_start_date=date("Y-m-d",strtotime($contract_start_date));
		$contract_end_date=date("Y-m-d",strtotime($contract_end_date));
		$sale_date=date("Y-m-d",strtotime($sale_date));
		
		$customer_id=1;
		
		if(isset($btn_confirm) && !empty($btn_confirm))
		{
			/* $this->load->library('form_validation');
			$this->form_validation->set_rules('branch_id', 'Branch Name','required'); 
			$this->form_validation->set_rules('customer_id', 'Customer Name','required'); 
			$this->form_validation->set_rules('sale_person_name', 'Company','required'); 
			$this->form_validation->set_rules('dispenser_id', 'Dispenser','required'); 			
			$this->form_validation->set_message('required', '* %s required');
			$this->form_validation->set_message('isset', '* required');
			$this->form_validation->set_error_delimiters('<span class="error">', '</span>');
			if ($this->form_validation->run() == FALSE)
			{
				
				$this->_page_data['purpose']=$purpose;
				$this->_page_data['page_title']=$purpose." Dispenser Sale Data";
				$this->_page_data['bredcrum']=array(
												'Dispenser Sales'=>'#',
												' Manage Dispenser Sales'=>site_url('gc/dispenser_sale_data/list_dispenser_sale_data'),
												$purpose.' Dispenser Sale Data'=>'#',
												);
												
				$this->_page_data['form_action'] = 'gc/dispenser_sale_data/submit_dispenser_sale_data';
				$this->load->view('gc/dispenser_sale_data_manage.php',$this->_page_data);
			}
			else
			{ */	
				if($_FILES['attachment']['name']!="")
				{
					$upload_path = CONTRACT_PATH.'/'.$company_id.'/';
					$upload_research_target_dir = CONTRACT_PATH;
					$associateUploadDocument = $_FILES['attachment']['name'];
					if (!file_exists($upload_research_target_dir.'/'.$customer_id)) {
						mkdir($upload_research_target_dir.'/'.$customer_id, 0777,TRUE);
					}
					
					$upload_research_target_dir = CONTRACT_PATH.$customer_id."/";
					$userfile_extn = explode(".", strtolower($_FILES['attachment']['name']));	
					$AssociatehDocument=$userfile_extn[0].time().".".$userfile_extn[1];
					
					$imageFileTypeUpload = strtolower(pathinfo($associateUploadDocument,PATHINFO_EXTENSION));
					$main_research_target_file = $upload_research_target_dir .$AssociatehDocument;
					$main_research_target_file_send =$AssociatehDocument;
					$uploadOk = 1;	
					// Check file size					  
					if ($_FILES["attachment"]["size"] > 5242880) {
						$err_msg =  "Sorry, your file is large. File size of the document should be less than 5 MB";
						$uploadOk = 0;
					}
					
					// Allow certain file formats
					 if($imageFileTypeUpload != "png" && $imageFileTypeUpload != "jpeg" && $imageFileTypeUpload != "jpg") {
						$err_msg =  "Sorry, only JPEG,JPG,PNG files are allowed.";
						$uploadOk = 0;
					}
					
					if ($uploadOk == 1)			 
					{
						 if (move_uploaded_file($_FILES["attachment"]["tmp_name"], $main_research_target_file)) 
						 {					 
							echo $err_msg="uploded ";
						} else {
							echo $err_msg =  "Sorry, there was an error uploading your file.";
							$uploadOk = 0;
						}
					}
				}
				
			
				 $data_log = array(
									'company_branch_id'=>$branch_name,
									'customer_id'=>$customer_id,
									'sales_person_name'=>$sale_person_name,
									'product_id'=>$dispenser_id,
									'dispenser_quantity'=>$dispenser_quantity,
									'installation_date'=>$sale_date,
									'sales_type'=>'',
									'is_contract_signed'=>$contract_sign,
									'contract_start_date'=>$contract_start_date,
									'contract_end_date'=>$contract_end_date,
									'contract_attachment'=>$AssociatehDocument,
									'comments'=>$comments,
									'is_active'=>'0',
									'created_on' =>date("Y-m-d H:i:s")							
								); 
				 $this->master_model->insert_record(TABLE_DISPENSER_SALES,$data_log);
				$dispenser_sales_id = $this->db->insert_id();
				
				//$dispenser_sales_id = $this->encrypt->encode(($dispenser_sales_id));
				$dispenser_sales_id=encrypt_decrypt_parameters($dispenser_sales_id,'encrypt');
				redirect(DISPENSER_SALES_DATA."/refill_and_track_data/".$dispenser_sales_id);
			//}
		}
		
	}

	function refill_and_track_data($dispenser_sales_id) {
		if($purpose=='')
			$purpose='Add';
				
		// $dispenser_sales_id = $this->encrypt->decode(($dispenser_sales_id));
		$dispenser_sales_id=encrypt_decrypt_parameters($dispenser_sales_id,'decrypt');
		$cond=array();		
		$cond[]=array('where','dispenser_sales_id',$dispenser_sales_id);
		$cond[]=array('join',TABLE_CUSTOMER.' as C','A.customer_id=C.customer_id','left');
		$cond[]=array('join',TABLE_COMPANY_BRANCH.' as D','A.company_branch_id=D.company_branch_id','left');		
		$cond[]=array('join',TABLE_PRODUCT.' as B','A.product_id=B.product_id','left');		
		$company_array=array(
							'table_name'=>TABLE_DISPENSER_SALES." as A",
							'table_fields'=>'A.sales_person_name,A.dispenser_quantity,A.installation_date,C.customer_name,D.company_branch_name, B.product_name ,B.stock_quantity, B.product_prefix',
							'condition'=>$cond,
							'sort_by' => 'dispenser_sales_id', 
							'limit'=>'',
							'offset'=>''
							);											
		$company_data=$this->master_model->select_data($company_array);
		$company_cnt_data=count($company_data);
		
		
		if($company_cnt_data >0){
			$this->_page_data['sales_person_name']= isset($company_data[0]['sales_person_name']) && !empty($company_data[0]['sales_person_name']) ? $company_data[0]['sales_person_name'] :'';
			$this->_page_data['company_name']= isset($company_data[0]['company_name']) && !empty($company_data[0]['company_name']) ? $company_data[0]['company_name'] :'';
			$this->_page_data['dispenser_quantity']= isset($company_data[0]['dispenser_quantity']) && !empty($company_data[0]['dispenser_quantity']) ? $company_data[0]['dispenser_quantity'] :'';
			$this->_page_data['installation_date']= isset($company_data[0]['installation_date']) && !empty($company_data[0]['installation_date']) ? $company_data[0]['installation_date'] :'';
			$this->_page_data['product_name']= isset($company_data[0]['product_name']) && !empty($company_data[0]['product_name']) ? $company_data[0]['product_name'] :'';
			$this->_page_data['product_prefix']= isset($company_data[0]['product_prefix']) && !empty($company_data[0]['product_prefix']) ? $company_data[0]['product_prefix'] :'';
			$this->_page_data['stock_quantity']= isset($company_data[0]['stock_quantity']) && !empty($company_data[0]['stock_quantity']) ? $company_data[0]['stock_quantity'] :'';
			$this->_page_data['customer_name']= isset($company_data[0]['customer_name']) && !empty($company_data[0]['customer_name']) ? $company_data[0]['customer_name'] :'';$this->_page_data['company_branch_name']= isset($company_data[0]['company_branch_name']) && !empty($company_data[0]['company_branch_name']) ? $company_data[0]['company_branch_name'] :'';
		}
		
		
		$refill_cond = array();
		$refill_cond[] = array('where','is_active','1');
		$refill_cond[] = array('where','product_type','refill');
		$select_array = array(
								'table_name'=>TABLE_PRODUCT,
								'table_fields'=>'product_name,product_id',
								'condition'=>$refill_cond,
								'sort_by'=>'product_id',
								'order_by_field'=>'product_name',
								'order'=>'ASC',
								'limit'=>'',
								'offset'=>''
								);
		$refill_data=$this->master_model->select_data($select_array);
		$refill_cnt_data=count($refill_data);
		$this->_page_data['refill_array'] = '';
		if($refill_cnt_data > 0)
		{
			foreach($refill_data as $cKey => $cValue)
			{
				$this->_page_data['refill_array'][''] = 'Select Refill Name';
				$this->_page_data['refill_array'][$cValue['product_id']] = $cValue['product_name'];
			}
		}
		
		$this->_page_data['purpose']=$purpose;
		$this->_page_data['page_title']=$purpose." Dispenser Sale Data";
		$this->_page_data['bredcrum']=array(
										'Dispenser Sales'=>'#',
										' Manage Dispenser Sales'=>site_url('gc/dispenser_sale_data/list_dispenser_sale_data'),
										$purpose.' Dispenser Sale Data'=>'#',
										'Refill Data'=>'#',
										);
		$this->load->view('gc/add_refill_details.php',$this->_page_data);
		$this->_page_data['form_action'] = 'gc/dispenser_sale_data/submit_refill_details';
	}
	
	function submit_refill_details()
	{
		print_r($_POST);
	}
	
	function search_return_dispenser($purpose=NULL) {
		if($purpose=='')
			$purpose='Add';
		
		$this->_page_data['purpose']=$purpose;
		$this->_page_data['page_title']="Return Dispenser";
		$this->_page_data['bredcrum']=array(
										'Dispenser Sales'=>'#',
										'Manage Dispenser Sales'=>site_url('gc/dispenser_sale_data/list_dispenser_sale_data'),
										'Return Dispenser'=>'#',
										'Refill Data'=>'#',
										);
		$this->load->view('gc/search_return_dispenser.php',$this->_page_data);
	}
	
	function return_dispenser_list($purpose=NULL) {
		if($purpose=='')
			$purpose='Add';
		
		$this->_page_data['purpose']=$purpose;
		$this->_page_data['page_title']="Return Dispenser Details";
		$this->_page_data['bredcrum']=array(
										'Dispenser Sales'=>'#',
										'Manage Dispenser Sales'=>site_url('gc/dispenser_sale_data/list_dispenser_sale_data'),
										'Return Dispenser'=>'#',
										'Refill Data'=>'#',
										);
		$this->load->view('gc/return_dispenser_list.php',$this->_page_data);
	}
	
	function return_dispenser()
	{
		if($purpose=='')
			$purpose='Add';
		
		$this->_page_data['purpose']=$purpose;
		$this->_page_data['page_title']="Return Dispenser";
		$this->_page_data['bredcrum']=array(
										'Dispenser Sales'=>'#',
										'Manage Dispenser Sales'=>site_url('gc/dispenser_sale_data/list_dispenser_sale_data'),
										'Return Dispenser'=>'#',
										'Refill Data'=>'#',
										);
		$this->load->view('gc/return_dispenser.php',$this->_page_data);
	}
	
	
}