<?php	if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Currency extends CI_Controller {

	function __construct()	{
		parent::__construct();
		$this->load->model('master_model');
		$this->load->library('form_validation');
		$this->load->helper(array('form','url'));
		$language = $this->session->userdata('language'); 
    		if ($language=='hindi') {
      	       $this->lang->load('hindi', '');
   			}else{
      		    $this->lang->load('masters', '');
            }
            //error_reporting(E_ALL);
		//$this->lang->load('masters', '');	
		//$this->session->keep_flashdata('message');
            
		
	}

	function index()	{	
		$this->list_currency();
	}
	
	function list_currency() {
         admin_auth();
		$this->page_data['page_title']="List Currency";
	  	$this->page_data['bredcrum']=array(	
	  									'Master'=>'#',		                           
										'Currency'=>'#',
	 									'List of Currency'=>'#',
	 									);
	  	$condition = array();

        $condition[] = array('join',TABLE_COUNTRY.' as cy','cy.country_id = c.country_id','left');

		$selected_array = array( 
			                   'table_name' =>TABLE_CURRENCY. ' as c',
			                   'table_fields' =>'c.is_active,c.currency_id,c.currency_name,c.currency_code,cy.country_name',
			                   'condition'=>$condition,
			                   'order_by_field'=>'currency_name',
			                   'limit'=>'',
			                   'offset'=>'',
			                   'order'=>'DESC'
		);

		
		$currency['currency'] = $this->master_model->select_data($selected_array); 
		//dump($this->db->last_query());
		if(!empty($currency['currency'])&& is_array($currency['currency'])){
							
				 $this->page_data['currency'] =   $currency['currency'];
		 	

  	    }
             
  	        $this->load->view('gc/list_currency',$this->page_data);
	}	
	
	function view_currency($currency_id="") {
     admin_auth();
        $id=$this->encrypt->decode($currency_id);
		$id=encrypt_decrypt_parameters($currency_id,'decrypt');
		$this->data['page_title']="View Currency";
		$this->data['bredcrum']=array(
			 							'Master'=>'#',	
			 							'Currency'=>'#',
										'List of Currency'=>site_url('gc/currency/list_currency'),
										'View Currency'=>'#',
										);

				$condition = array();

        	$condition[] = array('join',TABLE_COUNTRY.' as cy','cy.country_id = c.country_id','left');
			
		    $condition[]=array('where','c.currency_id',$id);

		   $selected_array=array(
								'table_name' =>TABLE_CURRENCY.' as c',								
								'table_fields'=>'c.currency_name,c.currency_code,c.currency_id,cy.country_name',
								'limit'=>'',
								'offset'=>'',
								'condition'=>$condition							
					        );
		$currency['currency'] = $this->master_model->select_data($selected_array);
		
		if(!empty($currency['currency'] )&& is_array($currency['currency']))
			{
				 $this->data['currency'] = $currency['currency'] ;
				 
  	  			 
  	        }
		$this->load->view('gc/view_currency.php',$this->data);
		
		
	}
	
	function manage_currency($currency_id="") {
		admin_auth();

		$id=$this->encrypt->decode($currency_id);
		$id=encrypt_decrypt_parameters($currency_id,'decrypt');
		$cur_Currency_Name=$this->lang->line('cur_Currency_Name', FALSE);
		$ci_Currency_Code=$this->lang->line('ci_Currency_Code', FALSE);
		
		$this->_page_data['country'] =$this->fetch_country();

		if ($id) {$this->_page_data['page_title']="Edit Currency";
				   $this->_page_data['bredcrum']=array(	
				   					    'Master'=>'#',										
										'Currency'=>'#',
										'List Currency'=>site_url(CURRENCY.'list_currency'),
										'Edit Currency'=>'#',
										);
		}else{$this->_page_data['page_title']="Add Currency";
				$this->_page_data['bredcrum']=array(
										'Master'=>'#',											
										'Currency'=>'#',
										'Add Currency'=>'#',
										);
		}
		
		$this->_page_data['cur_Currency_Name']=$cur_Currency_Name;
		$this->_page_data['ci_Currency_Code']=$ci_Currency_Code;

		
		if (!$id) {
            
	       $this->load->view('gc/add_currency.php',$this->_page_data);

		}else{
                     
			
		    $condition[]=array('where','currency_id',$id);

		   $selected_array=array(
								'table_name' =>TABLE_CURRENCY,								
								'table_fields'=>'currency_name,currency_code,currency_id,country_id',
								'limit'=>'',
								'offset'=>'',
								'condition'=>$condition							
					        );
		$currency['currency'] = $this->master_model->select_data($selected_array);
		
		if(!empty($currency['currency'] )&& is_array($currency['currency']))
			{
				 $this->_page_data['currency'] = $currency['currency'] ;
				 
  	  			 
  	        }
		  $this->load->view('gc/add_currency.php',$this->_page_data); 
		
		}
		
	}


    function add_currency(){
			 
			admin_auth();
			$ci_Currency_created=$this->lang->line('ci_Currency_created', FALSE);
		 	$ci_Currency_updated=$this->lang->line('ci_Currency_updated', FALSE);
		 	$ci_Currency_present=$this->lang->line('ci_Currency_present', FALSE);

			$id = check_injections_filter($this->input->post('hidden'));
			$currency_name = check_injections_filter($this->input->post('currency_name'));
			$currency_code = check_injections_filter($this->input->post('currency_code'));
			$country_id = check_injections_filter($this->input->post('country_id'));
			$s_currency_name=strtolower($currency_name);
			$s_currency_code=strtolower($currency_code);
			$user_id = $this->session->userdata('user_id');

			$this->form_validation->set_rules('currency_name', 'Currency Name', 'required');
			$this->form_validation->set_rules('currency_code', 'Currency Code', 'required');
			$this->form_validation->set_rules('country_id', 'Country Name', 'required');
			if ($this->form_validation->run() == FALSE)
            {
                    $this->manage_currency();
            }else{
            	


    		    	if ($id) {
    		    	$condition[] = array('where','country_id',$country_id);
    		    	$condition[] = array('or_where','LOWER(currency_name)',$s_currency_name);
    		      				
    				$condition[] = array('where_not_in','currency_id',$id);
    				
    		    	}else{
    		     	$condition[] = array('where','LOWER(currency_name)',$s_currency_name);
    		     	$condition[] = array('or_where','country_id',$country_id);
    	        // $condition[] = array('where','LOWER(currency_code)',$s_currency_code);
    	        
    		    }
    	
    	            $selected_array=array(
								'table_name' =>TABLE_CURRENCY,								
								'table_fields'=>'currency_name,currency_code,currency_id,country_id',
								'limit'=>'',
								'offset'=>'',
								'condition'=>$condition							
					        );

    			    $currency['currency'] = $this->master_model->select_data($selected_array);
    			    // dump($this->db->last_query());
    			    // exit;
    			  
    			    if(!empty($currency['currency']))
				    {
					 $this->session->set_flashdata('message',$ci_Currency_present);
				     redirect('gc/currency/manage_currency');
				    }else{
			            if (!$id) {
			       	       $currency_data=array(
								'currency_name' => $currency_name,								
								'currency_code' =>$currency_code,
								'country_id' =>$country_id,
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' => '',	
								'modified_on' => date("Y-m-d H:i:s")
								
					    	);
				            $this->session->set_flashdata('message',$ci_Currency_created);
						    $this->master_model->insert_record('currency',$currency_data);
			   			 redirect('gc/currency/list_currency/');
				        }else{
						    $this->session->set_flashdata('message',$ci_Currency_updated);
						    $currency_data=array(
								'currency_name' => $currency_name,								
								'currency_code' =>$currency_code,
								'country_id' =>$country_id,
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' =>$user_id,	
								'modified_on' => date("Y-m-d H:i:s")
								
					        );
						    $condition=array('currency_id'=>$id);
						    $this->master_model->update_record('currency',$currency_data,$condition);
					        redirect('gc/currency/list_currency');
			            }
		        }
            }			
    }
     function fetch_country(){
    	//admin_auth();
    	$condition[] = array('where','is_active','1');
    	$selected_array = array( 
			                   'table_name' =>TABLE_COUNTRY,
			                   'table_fields' =>'country_id,country_name,is_active',
			                   'condition'=>$condition,
			                   'limit'=>'',
			                   'offset'=>'',
			                   'order_by_field'=>'Asc'
		);

		return $this->master_model->select_data($selected_array);		         
    }

    function disable_currency($currency_id){
    	admin_auth();
    	$id=$this->encrypt->decode($currency_id);
		$id=encrypt_decrypt_parameters($currency_id,'decrypt');
		$ci_Currency_disable=$this->lang->line('ci_Currency_disable', FALSE);
     	$currency_data=array(
								'is_active' =>'0',								
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' => $user_id,	
								'modified_on' => date("Y-m-d H:i:s")								
					    );
     	$condition=array('currency_id'=>$id);
     	$this->session->set_flashdata('message',$ci_Currency_disable);
		$this->master_model->update_record(TABLE_CURRENCY,$currency_data,$condition);
		redirect('gc/currency/list_currency');
    }
      function enable_currency($currency_id){
      	admin_auth();
		$ci_Currency_enable=$this->lang->line('ci_Currency_enable', FALSE);
      	$id=$this->encrypt->decode($currency_id);
		$id=encrypt_decrypt_parameters($currency_id,'decrypt');
      $currency_data=array(
								'is_active' =>'1',								
								'created_on' => date("Y-m-d H:i:s"),
								'created_by' =>$user_id,
								'modified_by' => $user_id,	
								'modified_on' => date("Y-m-d H:i:s")								
					    );
     	$condition=array('currency_id'=>$id);
        $this->session->set_flashdata('message',$ci_Currency_enable);
		$this->master_model->update_record(TABLE_CURRENCY,$currency_data,$condition);
		redirect('gc/currency/list_currency');

    }
   
}